/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin;

import com.vaadin.server.SizeWithUnit;
import com.vaadin.server.Sizeable;
import java.io.Serializable;

public class MSize
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final MSize FULL_WIDTH = MSize.width(100.0f, Sizeable.Unit.PERCENTAGE);
    public static final MSize FULL_HEIGHT = MSize.height(100.0f, Sizeable.Unit.PERCENTAGE);
    public static final MSize FULL_SIZE = MSize.size(100.0f, Sizeable.Unit.PERCENTAGE, 100.0f, Sizeable.Unit.PERCENTAGE);
    public static final MSize HALF_WIDTH = MSize.width(50.0f, Sizeable.Unit.PERCENTAGE);
    public static final MSize HALF_HEIGHT = MSize.height(50.0f, Sizeable.Unit.PERCENTAGE);
    public static final MSize HALF_SIZE = MSize.size(50.0f, Sizeable.Unit.PERCENTAGE, 50.0f, Sizeable.Unit.PERCENTAGE);
    private float width = -1.0f;
    private float height = -1.0f;
    private Sizeable.Unit widthUnit = Sizeable.Unit.PIXELS;
    private Sizeable.Unit heightUnit = Sizeable.Unit.PIXELS;

    private MSize(float width, Sizeable.Unit widthUnit, float height, Sizeable.Unit heightUnit) {
        this.width = width;
        this.widthUnit = widthUnit;
        this.height = height;
        this.heightUnit = heightUnit;
    }

    public float getWidth() {
        return this.width;
    }

    public Sizeable.Unit getWidthUnit() {
        return this.widthUnit;
    }

    public float getHeight() {
        return this.height;
    }

    public Sizeable.Unit getHeightUnit() {
        return this.heightUnit;
    }

    public static MSize width(float width, Sizeable.Unit widthUnit) {
        return new MSize(width, widthUnit, -1.0f, Sizeable.Unit.PIXELS);
    }

    public static MSize width(String width) {
        SizeWithUnit size = SizeWithUnit.parseStringSize((String)width);
        return size != null ? new MSize(size.getSize(), size.getUnit(), -1.0f, Sizeable.Unit.PIXELS) : new MSize(-1.0f, Sizeable.Unit.PIXELS, -1.0f, Sizeable.Unit.PIXELS);
    }

    public static MSize height(float height, Sizeable.Unit heightUnit) {
        return new MSize(-1.0f, Sizeable.Unit.PIXELS, height, heightUnit);
    }

    public static MSize height(String height) {
        SizeWithUnit size = SizeWithUnit.parseStringSize((String)height);
        return size != null ? new MSize(-1.0f, Sizeable.Unit.PIXELS, size.getSize(), size.getUnit()) : new MSize(-1.0f, Sizeable.Unit.PIXELS, -1.0f, Sizeable.Unit.PIXELS);
    }

    public static MSize size(float width, Sizeable.Unit widthUnit, float height, Sizeable.Unit heightUnit) {
        return new MSize(width, widthUnit, height, heightUnit);
    }

    public static MSize size(String width, String height) {
        float w = -1.0f;
        float h = -1.0f;
        Sizeable.Unit wu = Sizeable.Unit.PIXELS;
        Sizeable.Unit hu = Sizeable.Unit.PIXELS;
        SizeWithUnit size = SizeWithUnit.parseStringSize((String)width);
        if (size != null) {
            w = size.getSize();
            wu = size.getUnit();
        }
        if ((size = SizeWithUnit.parseStringSize((String)height)) != null) {
            h = size.getSize();
            hu = size.getUnit();
        }
        return new MSize(w, wu, h, hu);
    }
}

