/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.fields;

import com.vaadin.data.BeanValidationBinder;
import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.StatusChangeEvent;
import com.vaadin.data.StatusChangeListener;
import com.vaadin.shared.util.SharedUtil;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomField;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.util.ReflectTools;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public abstract class AbstractElementCollection<ET, CT extends Collection<ET>>
extends CustomField<CT> {
    private static final long serialVersionUID = 7785110162928180695L;
    private static ValidatorFactory factory;
    private transient Validator javaxBeanValidator;
    private static final Method addedMethod;
    private static final Method removedMethod;
    private Instantiator<ET> instantiator;
    private Instantiator<?> oldEditorInstantiator;
    private EditorInstantiator<?, ET> newEditorInstantiator;
    private final Class<ET> elementType;
    private final Class<?> editorType;
    protected ET newInstance;
    private CT value;
    StatusChangeListener scl = new StatusChangeListener(){

        public void statusChange(StatusChangeEvent event) {
            Object bean = event.getBinder().getBean();
            if (bean == AbstractElementCollection.this.newInstance) {
                Binder binder = event.getBinder();
                boolean valid = binder.isValid();
                if (!valid || !AbstractElementCollection.this.isValidBean(bean)) {
                    return;
                }
                AbstractElementCollection.this.getAndEnsureValue().add(AbstractElementCollection.this.newInstance);
                AbstractElementCollection.this.fireEvent(new ElementAddedEvent(AbstractElementCollection.this, AbstractElementCollection.this.newInstance));
                AbstractElementCollection.this.setPersisted(AbstractElementCollection.this.newInstance, true);
                AbstractElementCollection.this.onElementAdded();
            }
            this.fireValueChange();
        }

        private void fireValueChange() {
            AbstractElementCollection.this.fireEvent((EventObject)new HasValue.ValueChangeEvent((Component)AbstractElementCollection.this, null, true));
        }
    };
    private List<String> visibleProperties;
    private boolean allowNewItems = true;
    private boolean allowRemovingItems = true;
    private boolean allowEditItems = true;
    private final Map<ET, EditorStuff> pojoToEditor = new IdentityHashMap<ET, EditorStuff>();
    private final Map<String, String> propertyToHeader = new HashMap<String, String>();

    public AbstractElementCollection<ET, CT> addElementAddedListener(ElementAddedListener<ET> listener) {
        this.addListener(ElementAddedEvent.class, listener, addedMethod);
        return this;
    }

    public AbstractElementCollection<ET, CT> removeElementAddedListener(ElementAddedListener listener) {
        this.removeListener(ElementAddedEvent.class, listener, addedMethod);
        return this;
    }

    public AbstractElementCollection<ET, CT> addElementRemovedListener(ElementRemovedListener<ET> listener) {
        this.addListener(ElementRemovedEvent.class, listener, removedMethod);
        return this;
    }

    public AbstractElementCollection<ET, CT> removeElementRemovedListener(ElementRemovedListener listener) {
        this.removeListener(ElementRemovedEvent.class, listener, removedMethod);
        return this;
    }

    public boolean isAllowNewItems() {
        return this.allowNewItems;
    }

    public boolean isAllowRemovingItems() {
        return this.allowRemovingItems;
    }

    public boolean isAllowEditItems() {
        return this.allowEditItems;
    }

    public AbstractElementCollection<ET, CT> setAllowEditItems(boolean allowEditItems) {
        this.allowEditItems = allowEditItems;
        return this;
    }

    public AbstractElementCollection<ET, CT> setAllowRemovingItems(boolean allowRemovingItems) {
        this.allowRemovingItems = allowRemovingItems;
        return this;
    }

    public AbstractElementCollection<ET, CT> withCaption(String caption) {
        this.setCaption(caption);
        return this;
    }

    private Collection<ET> getAndEnsureValue() {
        AbstractCollection value = this.getValue();
        if (value == null) {
            Class<List> fieldType = List.class;
            if (fieldType.isInterface()) {
                value = fieldType == List.class ? new ArrayList() : new HashSet();
            } else {
                try {
                    value = (Collection)fieldType.newInstance();
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    throw new RuntimeException("Could not instantiate the used colleciton type", ex);
                }
            }
            this.setValue(value);
        }
        return value;
    }

    public AbstractElementCollection<ET, CT> setAllowNewElements(boolean allowNewItems) {
        this.allowNewItems = allowNewItems;
        return this;
    }

    public AbstractElementCollection(Class<ET> elementType, Class<?> formType) {
        this.elementType = elementType;
        this.editorType = formType;
    }

    public AbstractElementCollection(Class<ET> elementType, Instantiator<ET> i, Class<?> formType) {
        this.elementType = elementType;
        this.instantiator = i;
        this.editorType = formType;
    }

    public Class<ET> getElementType() {
        return this.elementType;
    }

    protected ET createInstance() {
        if (this.instantiator != null) {
            return this.instantiator.create();
        }
        try {
            return this.elementType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Object createEditorInstance(ET pojo) {
        if (this.newEditorInstantiator != null) {
            return this.newEditorInstantiator.create(pojo);
        }
        if (this.oldEditorInstantiator != null) {
            return this.oldEditorInstantiator.create();
        }
        try {
            return this.editorType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public EditorInstantiator<?, ET> getNewEditorInstantiator() {
        return this.newEditorInstantiator;
    }

    public void setNewEditorInstantiator(EditorInstantiator<?, ET> editorInstantiator) {
        this.newEditorInstantiator = editorInstantiator;
    }

    public Instantiator<?> getEditorInstantiator() {
        return this.oldEditorInstantiator;
    }

    public void setEditorInstantiator(Instantiator<?> editorInstantiator) {
        this.oldEditorInstantiator = editorInstantiator;
    }

    protected EditorStuff provideEditorStuff(ET pojo) {
        EditorStuff editorsstuff = this.pojoToEditor.get(pojo);
        if (editorsstuff == null) {
            Object o = this.createEditorInstance(pojo);
            Binder<ET> binder = this.instantiateBinder(this.elementType);
            binder.bindInstanceFields(o);
            binder.setBean(pojo);
            binder.addStatusChangeListener(this.scl);
            editorsstuff = new EditorStuff(binder, o);
            this.pojoToEditor.put(pojo, editorsstuff);
        }
        return editorsstuff;
    }

    protected Binder<ET> instantiateBinder(Class<ET> elementClass) {
        return new BeanValidationBinder(elementClass);
    }

    protected Binder<ET> getFieldGroupFor(ET pojo) {
        return this.provideEditorStuff(pojo).bfg;
    }

    protected Component getComponentFor(ET pojo, String property) {
        EditorStuff editorsstuff = this.provideEditorStuff(pojo);
        Component c = null;
        Optional binding = editorsstuff.bfg.getBinding(property);
        if (binding.isPresent()) {
            c = (Component)((Binder.Binding)binding.get()).getField();
        } else {
            try {
                Field f = this.editorType.getDeclaredField(property);
                f.setAccessible(true);
                c = (Component)f.get(editorsstuff.editor);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                Logger.getLogger(AbstractElementCollection.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (c == null) {
                c = new Label("");
            }
        }
        return c;
    }

    public void addElement(ET instance) {
        this.getAndEnsureValue().add(instance);
        this.addInternalElement(instance);
        this.fireEvent((EventObject)new HasValue.ValueChangeEvent((Component)this, null, true));
        this.fireEvent((EventObject)((Object)new ElementAddedEvent<ET>(this, instance)));
    }

    public void removeElement(ET elemnentToBeRemoved) {
        this.removeInternalElement(elemnentToBeRemoved);
        this.getAndEnsureValue().remove(elemnentToBeRemoved);
        this.fireEvent((EventObject)new HasValue.ValueChangeEvent((Component)this, null, true));
        this.fireEvent((EventObject)((Object)new ElementRemovedEvent<ET>(this, elemnentToBeRemoved)));
    }

    public AbstractElementCollection<ET, CT> setVisibleProperties(List<String> properties) {
        this.visibleProperties = properties;
        return this;
    }

    public List<String> getVisibleProperties() {
        if (this.visibleProperties == null) {
            this.visibleProperties = new ArrayList<String>();
            for (Field f : this.editorType.getDeclaredFields()) {
                if (!HasValue.class.isAssignableFrom(f.getType())) continue;
                this.visibleProperties.add(f.getName());
            }
        }
        return this.visibleProperties;
    }

    public AbstractElementCollection<ET, CT> setVisibleProperties(List<String> properties, List<String> propertyHeaders) {
        this.visibleProperties = properties;
        Iterator<String> it = propertyHeaders.iterator();
        for (String prop : this.visibleProperties) {
            this.setPropertyHeader(prop, it.next());
        }
        return this;
    }

    public AbstractElementCollection<ET, CT> setPropertyHeader(String propertyName, String propertyHeader) {
        this.propertyToHeader.put(propertyName, propertyHeader);
        return this;
    }

    protected String getPropertyHeader(String propertyName) {
        String header = this.propertyToHeader.get(propertyName);
        if (header == null) {
            header = SharedUtil.propertyIdToHumanFriendly((Object)propertyName);
        }
        return header;
    }

    protected Component initContent() {
        return this.getLayout();
    }

    protected void doSetValue(CT newValue) {
        this.clear();
        this.value = newValue;
        if (this.value != null) {
            for (Object v : this.value) {
                this.addInternalElement(v);
            }
        }
        this.onElementAdded();
    }

    protected abstract void addInternalElement(ET var1);

    protected abstract void setPersisted(ET var1, boolean var2);

    protected abstract void removeInternalElement(ET var1);

    protected abstract Layout getLayout();

    protected abstract void onElementAdded();

    public CT getValue() {
        return this.value;
    }

    public boolean isValidBean(Object bean) {
        Set violations = this.getJavaxBeanValidator().validate(bean, new Class[0]);
        return violations.isEmpty();
    }

    protected static ValidatorFactory getJavaxBeanValidatorFactory() {
        if (factory == null) {
            factory = Validation.buildDefaultValidatorFactory();
        }
        return factory;
    }

    protected Validator getJavaxBeanValidator() {
        if (this.javaxBeanValidator == null) {
            this.javaxBeanValidator = AbstractElementCollection.getJavaxBeanValidatorFactory().getValidator();
        }
        return this.javaxBeanValidator;
    }

    static {
        addedMethod = ReflectTools.findMethod(ElementAddedListener.class, (String)"elementAdded", (Class[])new Class[]{ElementAddedEvent.class});
        removedMethod = ReflectTools.findMethod(ElementRemovedListener.class, (String)"elementRemoved", (Class[])new Class[]{ElementRemovedEvent.class});
    }

    private class EditorStuff
    implements Serializable {
        private static final long serialVersionUID = 5132645136059482705L;
        Binder<ET> bfg;
        Object editor;

        private EditorStuff(Binder<ET> editor, Object o) {
            this.bfg = editor;
            this.editor = o;
        }
    }

    public static interface EditorInstantiator<T, ET>
    extends Serializable {
        public T create(ET var1);
    }

    public static interface Instantiator<ET>
    extends Serializable {
        public ET create();
    }

    public static interface ElementRemovedListener<ET>
    extends Serializable {
        public void elementRemoved(ElementRemovedEvent<ET> var1);
    }

    public static interface ElementAddedListener<ET>
    extends Serializable {
        public void elementAdded(ElementAddedEvent<ET> var1);
    }

    public static class ElementRemovedEvent<ET>
    extends Component.Event {
        private static final long serialVersionUID = 574545902966053269L;
        private final ET element;

        public ElementRemovedEvent(AbstractElementCollection source, ET element) {
            super((Component)source);
            this.element = element;
        }

        public ET getElement() {
            return this.element;
        }
    }

    public static class ElementAddedEvent<ET>
    extends Component.Event {
        private static final long serialVersionUID = 2263765199849601501L;
        private final ET element;

        public ElementAddedEvent(AbstractElementCollection source, ET element) {
            super((Component)source);
            this.element = element;
        }

        public ET getElement() {
            return this.element;
        }
    }
}

