/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.fields;

import com.vaadin.data.HasValue;
import com.vaadin.event.FieldEvents;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.shared.Registration;
import com.vaadin.shared.ui.ValueChangeMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomField;
import com.vaadin.ui.Layout;
import com.vaadin.ui.TextField;
import org.vaadin.viritin.button.MButton;
import org.vaadin.viritin.layouts.MHorizontalLayout;

public class ClearableTextField
extends CustomField {
    private final TextField textfield = new TextField();
    private final MButton clearButton = (MButton)new MButton((Resource)VaadinIcons.CLOSE).withStyleName(new String[]{"icon-only"});
    private final MHorizontalLayout root = (MHorizontalLayout)((MHorizontalLayout)((MHorizontalLayout)new MHorizontalLayout().expand(new Component[]{this.textfield}).add(this.clearButton).withSpacing(false)).withFullWidth()).withStyleName(new String[]{"clearable-textfield"});

    public ClearableTextField() {
        this.clearButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                ClearableTextField.this.textfield.clear();
                ClearableTextField.this.textfield.focus();
            }
        });
        this.textfield.addValueChangeListener((HasValue.ValueChangeListener)new HasValue.ValueChangeListener<String>(){

            public void valueChange(HasValue.ValueChangeEvent<String> event) {
                ClearableTextField.this.setValue(event.getValue());
            }
        });
        this.textfield.setValueChangeMode(ValueChangeMode.LAZY);
        this.setWidth("300px");
    }

    public ClearableTextField(String caption) {
        this();
        this.setCaption(caption);
    }

    public ClearableTextField(String caption, String value) {
        this();
        this.setCaption(caption);
        this.textfield.setValue(value);
    }

    public TextField getTextfield() {
        return this.textfield;
    }

    public Layout getRoot() {
        return this.root;
    }

    public MButton getClearButton() {
        return this.clearButton;
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.textfield.setReadOnly(readOnly);
        this.clearButton.setEnabled(!readOnly);
    }

    public Registration addClickListener(Button.ClickListener listener) {
        return this.clearButton.addClickListener(listener);
    }

    public void click() {
        this.clearButton.click();
    }

    public void setClickShortcut(int keyCode, int ... modifiers) {
        this.clearButton.setClickShortcut(keyCode, modifiers);
    }

    public void removeClickShortcut() {
        this.clearButton.removeClickShortcut();
    }

    public void setIcon(Resource icon, String iconAltText) {
        this.clearButton.setIcon(icon, iconAltText);
    }

    public String getIconAlternateText() {
        return this.clearButton.getIconAlternateText();
    }

    public void setIconAlternateText(String iconAltText) {
        this.clearButton.setIconAlternateText(iconAltText);
    }

    public void setHtmlContentAllowed(boolean htmlContentAllowed) {
        this.clearButton.setHtmlContentAllowed(htmlContentAllowed);
    }

    public boolean isHtmlContentAllowed() {
        return this.clearButton.isHtmlContentAllowed();
    }

    public void clear() {
        super.clear();
        this.textfield.clear();
    }

    public boolean isEmpty() {
        return super.isEmpty();
    }

    public int getMaxLength() {
        return this.textfield.getMaxLength();
    }

    public void setMaxLength(int maxLength) {
        this.textfield.setMaxLength(maxLength);
    }

    public String getPlaceholder() {
        return this.textfield.getPlaceholder();
    }

    public void setPlaceholder(String inputPrompt) {
        this.textfield.setPlaceholder(inputPrompt);
    }

    public void selectAll() {
        this.textfield.selectAll();
    }

    public void setSelection(int pos, int length) {
        this.textfield.setSelection(pos, length);
    }

    public void setCursorPosition(int pos) {
        this.textfield.setCursorPosition(pos);
    }

    public int getCursorPosition() {
        return this.textfield.getCursorPosition();
    }

    public Registration addFocusListener(FieldEvents.FocusListener listener) {
        return this.textfield.addFocusListener(listener);
    }

    public Registration addBlurListener(FieldEvents.BlurListener listener) {
        return this.textfield.addBlurListener(listener);
    }

    public ClearableTextField withCaption(String caption) {
        super.setCaption(caption);
        return this;
    }

    public ClearableTextField withFullWidth() {
        this.setWidth("100%");
        return this;
    }

    public ClearableTextField withValue(String value) {
        this.setValue(value);
        return this;
    }

    public ErrorMessage getErrorMessage() {
        ErrorMessage errorMessage = super.getErrorMessage();
        if (errorMessage == null) {
            this.textfield.removeStyleName("error");
        } else {
            this.textfield.addStyleName("error");
        }
        return errorMessage;
    }

    public void setComponentError(ErrorMessage componentError) {
        super.setComponentError(componentError);
        if (componentError == null) {
            this.textfield.removeStyleName("error");
        } else {
            this.textfield.addStyleName("error");
        }
    }

    public void focus() {
        this.textfield.focus();
    }

    protected Component initContent() {
        return this.root;
    }

    public void attach() {
        super.attach();
        Page.getCurrent().getStyles().add(".clearable-textfield .v-widget {\n\tborder-radius: 4px 4px 4px 4px;\n}\n.clearable-textfield .v-slot:last-child>.v-widget {\n\tborder-top-left-radius: 0;\n\tborder-bottom-left-radius: 0; margin-left:-1px\n}\n\n.clearable-textfield .v-slot:first-child>.v-widget {\n\tborder-top-right-radius: 0;\n\tborder-bottom-right-radius: 0;\n}\n");
    }

    protected void doSetValue(Object newValue) {
        this.textfield.setValue(newValue.toString());
    }

    public Object getValue() {
        return this.textfield.getValue();
    }
}

