/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.fields;

import com.vaadin.data.Binder;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Label;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.vaadin.viritin.button.ConfirmButton;
import org.vaadin.viritin.button.MButton;
import org.vaadin.viritin.fields.AbstractElementCollection;
import org.vaadin.viritin.form.AbstractForm;
import org.vaadin.viritin.layouts.MGridLayout;

public class ElementCollectionField<ET, CT extends Collection<ET>>
extends AbstractElementCollection<ET, CT> {
    private static final long serialVersionUID = 8573373104105052804L;
    List<ET> items = new ArrayList<ET>();
    boolean inited = false;
    MGridLayout layout = new MGridLayout();
    private boolean visibleHeaders = true;
    private boolean requireVerificationForRemoval;
    private AbstractForm<ET> popupEditor;
    private String disabledDeleteThisElementDescription = "Fill this row to add a new element, currently ignored";
    private String deleteThisElementDescription = "Delete this element";

    public ElementCollectionField(Class<ET> elementType, Class<?> formType) {
        super(elementType, formType);
    }

    public ElementCollectionField(Class<ET> elementType, AbstractElementCollection.Instantiator i, Class<?> formType) {
        super(elementType, i, formType);
    }

    @Override
    public void addInternalElement(final ET v) {
        this.ensureInited();
        this.items.add(v);
        Binder<ET> fg = this.getFieldGroupFor(v);
        for (String property : this.getVisibleProperties()) {
            Optional binding = fg.getBinding(property.toString());
            Component c = null;
            if (!binding.isPresent()) {
                c = this.getComponentFor(v, property.toString());
                Logger.getLogger(ElementCollectionField.class.getName()).log(Level.WARNING, "No editor field for{0}", property);
            } else {
                c = (Component)((Binder.Binding)binding.get()).getField();
            }
            this.layout.addComponent(c);
            this.layout.setComponentAlignment(c, Alignment.MIDDLE_LEFT);
        }
        if (this.getPopupEditor() != null) {
            MButton b = ((MButton)new MButton((Resource)VaadinIcons.PENCIL).withStyleName(new String[]{"icon-only"})).withListener(new Button.ClickListener(){
                private static final long serialVersionUID = 5019806363620874205L;

                public void buttonClick(Button.ClickEvent event) {
                    ElementCollectionField.this.editInPopup(v);
                }
            });
            this.layout.add(b);
        }
        if (this.isAllowRemovingItems()) {
            this.layout.add(this.createRemoveButton(v));
        }
        if (!this.isAllowEditItems()) {
            fg.setReadOnly(true);
        }
    }

    protected Component createRemoveButton(final ET v) {
        Button b = this.requireVerificationForRemoval ? new ConfirmButton() : new MButton();
        b.setIcon((Resource)VaadinIcons.TRASH);
        b.addStyleName("icon-only");
        b.addStyleName("danger");
        b.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 5019806363620874205L;

            public void buttonClick(Button.ClickEvent event) {
                ElementCollectionField.this.removeElement(v);
            }
        });
        return b;
    }

    @Override
    public void removeInternalElement(ET v) {
        int index = this.itemsIdentityIndexOf(v);
        this.items.remove(index);
        int row = index + 1;
        this.layout.removeRow(row);
    }

    public GridLayout getLayout() {
        return this.layout;
    }

    @Override
    public void setPersisted(ET v, boolean persisted) {
        int row = this.itemsIdentityIndexOf(v) + 1;
        if (this.isAllowRemovingItems()) {
            Button c = (Button)this.layout.getComponent(this.layout.getColumns() - 1, row);
            if (persisted) {
                c.setDescription(this.getDeleteElementDescription());
            } else {
                for (int i = 0; i < this.getVisibleProperties().size(); ++i) {
                    try {
                        AbstractField abstractField = (AbstractField)this.layout.getComponent(i, row);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                c.setDescription(this.getDisabledDeleteElementDescription());
            }
            c.setEnabled(persisted);
        }
    }

    private int itemsIdentityIndexOf(Object o) {
        for (int index = 0; index < this.items.size(); ++index) {
            if (this.items.get(index) != o) continue;
            return index;
        }
        return -1;
    }

    private void ensureInited() {
        if (!this.inited) {
            this.layout.setSpacing(true);
            int columns = this.getVisibleProperties().size();
            if (this.isAllowRemovingItems()) {
                ++columns;
            }
            if (this.getPopupEditor() != null) {
                ++columns;
            }
            this.layout.setColumns(columns);
            if (this.visibleHeaders) {
                for (String property : this.getVisibleProperties()) {
                    Component header = this.createHeader(property);
                    this.layout.addComponent(header);
                }
                if (this.isAllowRemovingItems()) {
                    this.layout.newLine();
                }
            }
            this.inited = true;
        }
    }

    protected Component createHeader(Object property) {
        Label header = new Label(this.getPropertyHeader(property.toString()));
        header.setWidthUndefined();
        return header;
    }

    public ElementCollectionField<ET, CT> withEditorInstantiator(AbstractElementCollection.Instantiator instantiator) {
        this.setEditorInstantiator(instantiator);
        return this;
    }

    public ElementCollectionField<ET, CT> withNewEditorInstantiator(AbstractElementCollection.EditorInstantiator<?, ET> instantiator) {
        this.setNewEditorInstantiator(instantiator);
        return this;
    }

    public ElementCollectionField<ET, CT> withVisibleHeaders(boolean visibleHeaders) {
        this.visibleHeaders = visibleHeaders;
        return this;
    }

    public void clear() {
        if (this.inited) {
            this.items.clear();
            int rows = 1;
            while (this.layout.getRows() > rows) {
                this.layout.removeRow(rows);
            }
        }
    }

    public String getDisabledDeleteElementDescription() {
        return this.disabledDeleteThisElementDescription;
    }

    public void setDisabledDeleteThisElementDescription(String disabledDeleteThisElementDescription) {
        this.disabledDeleteThisElementDescription = disabledDeleteThisElementDescription;
    }

    public String getDeleteElementDescription() {
        return this.deleteThisElementDescription;
    }

    public void setDeleteThisElementDescription(String deleteThisElementDescription) {
        this.deleteThisElementDescription = deleteThisElementDescription;
    }

    @Override
    public void onElementAdded() {
        if (this.isAllowNewItems()) {
            this.newInstance = this.createInstance();
            this.addInternalElement(this.newInstance);
            this.setPersisted(this.newInstance, false);
        }
    }

    @Override
    public ElementCollectionField<ET, CT> setPropertyHeader(String propertyName, String propertyHeader) {
        super.setPropertyHeader(propertyName, propertyHeader);
        return this;
    }

    @Override
    public ElementCollectionField<ET, CT> setVisibleProperties(List<String> properties, List<String> propertyHeaders) {
        super.setVisibleProperties(properties, propertyHeaders);
        return this;
    }

    @Override
    public ElementCollectionField<ET, CT> setVisibleProperties(List<String> properties) {
        super.setVisibleProperties(properties);
        return this;
    }

    @Override
    public ElementCollectionField<ET, CT> setAllowNewElements(boolean allowNewItems) {
        super.setAllowNewElements(allowNewItems);
        return this;
    }

    @Override
    public ElementCollectionField<ET, CT> setAllowRemovingItems(boolean allowRemovingItems) {
        super.setAllowRemovingItems(allowRemovingItems);
        return this;
    }

    @Override
    public ElementCollectionField<ET, CT> withCaption(String caption) {
        super.withCaption(caption);
        return this;
    }

    @Override
    public ElementCollectionField<ET, CT> removeElementRemovedListener(AbstractElementCollection.ElementRemovedListener listener) {
        super.removeElementRemovedListener(listener);
        return this;
    }

    @Override
    public ElementCollectionField<ET, CT> addElementRemovedListener(AbstractElementCollection.ElementRemovedListener<ET> listener) {
        super.addElementRemovedListener(listener);
        return this;
    }

    @Override
    public ElementCollectionField<ET, CT> removeElementAddedListener(AbstractElementCollection.ElementAddedListener listener) {
        super.removeElementAddedListener(listener);
        return this;
    }

    @Override
    public ElementCollectionField<ET, CT> addElementAddedListener(AbstractElementCollection.ElementAddedListener<ET> listener) {
        super.addElementAddedListener(listener);
        return this;
    }

    public ElementCollectionField<ET, CT> expand(String ... propertyId) {
        for (String propertyId1 : propertyId) {
            int index = this.getVisibleProperties().indexOf(propertyId1);
            if (index == -1) {
                throw new IllegalArgumentException("The expanded property must available");
            }
            this.layout.setColumnExpandRatio(index, 1.0f);
        }
        if (this.layout.getWidth() == -1.0f) {
            this.layout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        }
        return this;
    }

    public ElementCollectionField<ET, CT> withFullWidth() {
        this.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        return this;
    }

    public ElementCollectionField<ET, CT> withId(String id) {
        this.setId(id);
        return this;
    }

    public ElementCollectionField<ET, CT> setRequireVerificationForRemoving(boolean requireVerification) {
        this.requireVerificationForRemoval = requireVerification;
        return this;
    }

    public AbstractForm<ET> getPopupEditor() {
        return this.popupEditor;
    }

    public void setPopupEditor(AbstractForm<ET> newPopupEditor) {
        this.popupEditor = newPopupEditor;
        if (newPopupEditor != null) {
            newPopupEditor.setSavedHandler(new AbstractForm.SavedHandler<ET>(){
                private static final long serialVersionUID = 389618696563816566L;

                @Override
                public void onSave(ET entity) {
                    ElementCollectionField.this.popupEditor.getPopup().close();
                }
            });
        }
    }

    public void editInPopup(ET entity) {
        this.getPopupEditor().setEntity(entity);
        this.getPopupEditor().openInModalPopup();
    }
}

