/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.layouts;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.VerticalLayout;
import java.util.Collection;
import java.util.Iterator;
import org.vaadin.viritin.fluency.ui.FluentVerticalLayout;

public class MVerticalLayout
extends VerticalLayout
implements FluentVerticalLayout<MVerticalLayout> {
    private static final long serialVersionUID = -1806208156595232451L;

    public MVerticalLayout() {
    }

    public MVerticalLayout(Component ... components) {
        this();
        this.addComponents(components);
    }

    public MVerticalLayout with(Component ... components) {
        this.addComponents(components);
        return this;
    }

    public MVerticalLayout alignAll(Alignment alignment) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            this.setComponentAlignment(component, alignment);
        }
        return this;
    }

    public MVerticalLayout expand(Component ... componentsToExpand) {
        if (this.getHeight() < 0.0f) {
            this.withFullHeight();
        }
        for (Component component : componentsToExpand) {
            if (component.getParent() != this) {
                this.addComponent(component);
            }
            this.setExpandRatio(component, 1.0f);
            component.setHeight(100.0f, Sizeable.Unit.PERCENTAGE);
        }
        return this;
    }

    public MVerticalLayout add(Component ... component) {
        return this.with(component);
    }

    public MVerticalLayout add(Collection<Component> component) {
        return this.with(component.toArray(new Component[component.size()]));
    }

    public MVerticalLayout add(Component component, Alignment alignment) {
        return this.add(component).withAlign(component, alignment);
    }

    public MVerticalLayout add(Component component, float ratio) {
        return this.add(component).withExpand(component, ratio);
    }

    public MVerticalLayout add(Component component, Alignment alignment, float ratio) {
        return this.add(component).withAlign(component, alignment).withExpand(component, ratio);
    }

    public MVerticalLayout withAlign(Component component, Alignment alignment) {
        this.setComponentAlignment(component, alignment);
        return this;
    }

    public MVerticalLayout withExpand(Component component, float ratio) {
        this.setExpandRatio(component, ratio);
        return this;
    }
}

