/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.button;

import com.vaadin.server.Resource;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.Button;
import java.util.LinkedHashSet;
import org.vaadin.viritin.fluency.ui.FluentAbstractComponent;

public class MButton
extends Button
implements FluentAbstractComponent<MButton> {
    private static final long serialVersionUID = 3859208260278798872L;
    private LinkedHashSet<MClickListener> mClickListeners;

    public MButton() {
    }

    public MButton(Resource icon) {
        this.setIcon(icon);
    }

    public MButton(Resource icon, Button.ClickListener listener) {
        super((String)null, listener);
        this.setIcon(icon);
    }

    public MButton(Resource icon, String caption, Button.ClickListener listener) {
        super((String)null, listener);
        this.setIcon(icon);
        this.setCaption(caption);
    }

    public MButton(String caption) {
        super(caption);
    }

    public MButton(String caption, Button.ClickListener listener) {
        super(caption, listener);
    }

    public MButton withListener(Button.ClickListener listener) {
        this.addClickListener(listener);
        return this;
    }

    public MButton withClickShortcut(int keycode, int ... modifiers) {
        this.setClickShortcut(keycode, modifiers);
        return this;
    }

    protected void fireClick(MouseEventDetails details) {
        super.fireClick(details);
        if (this.mClickListeners != null) {
            MClickListener[] array;
            for (MClickListener l : array = this.mClickListeners.toArray(new MClickListener[this.mClickListeners.size()])) {
                l.onClick();
            }
        }
    }

    public MButton addClickListener(MClickListener listener) {
        if (this.mClickListeners == null) {
            this.mClickListeners = new LinkedHashSet();
        }
        this.mClickListeners.add(listener);
        return this;
    }

    public MButton removeClickListener(MClickListener listener) {
        if (this.mClickListeners != null) {
            this.mClickListeners.remove(listener);
        }
        return this;
    }

    public static interface MClickListener {
        public void onClick();
    }
}

