/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.fields;

import com.vaadin.ui.Component;
import com.vaadin.ui.CustomField;
import com.vaadin.ui.Label;
import org.vaadin.viritin.fields.CaptionGenerator;
import org.vaadin.viritin.fluency.ui.FluentCustomField;
import org.vaadin.viritin.label.RichText;

public class LabelField<T>
extends CustomField<T>
implements FluentCustomField<LabelField<T>, T> {
    private static final long serialVersionUID = -3079451926367430515L;
    private T value;
    private CaptionGenerator<T> captionGenerator = new ToStringCaptionGenerator();
    private Label label = new RichText();

    protected void doSetValue(T value) {
        this.value = value;
        this.updateLabel();
    }

    public T getValue() {
        return this.value;
    }

    public LabelField(String caption) {
        this.setCaption(caption);
    }

    public LabelField() {
    }

    protected Component initContent() {
        this.updateLabel();
        return this.label;
    }

    protected void updateLabel() {
        String caption = this.captionGenerator != null ? this.captionGenerator.getCaption(this.getValue()) : this.getValue().toString();
        this.label.setValue(caption);
    }

    public void setCaptionGenerator(CaptionGenerator<T> captionGenerator) {
        this.captionGenerator = captionGenerator;
        this.updateLabel();
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public Label getLabel() {
        return this.label;
    }

    private static class ToStringCaptionGenerator<T>
    implements CaptionGenerator<T> {
        private static final long serialVersionUID = 1149675718238329960L;

        private ToStringCaptionGenerator() {
        }

        @Override
        public String getCaption(T option) {
            if (option == null) {
                return "";
            }
            return option.toString();
        }
    }
}

